/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IEntryValueFactory;
import com.aptana.editor.php.indexer.IReportable;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPathReference;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IncludePHPEntryValue;
import com.aptana.editor.php.internal.indexer.LambdaFunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.UnpackedElementIndex;
import com.aptana.editor.php.internal.indexer.UnpackedEntry;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class IndexPersistence {
    private static HashMap<Integer, IEntryValueFactory> factories;

    static {
        IConfigurationElement[] configurationElementsFor;
        factories = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("com.aptana.editor.php.indexerEntryValue");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String attribute = e.getAttribute("id");
            try {
                IEntryValueFactory vf = (IEntryValueFactory)e.createExecutableExtension("creator");
                factories.put(Integer.parseInt(attribute), vf);
            }
            catch (CoreException e1) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading indexer entry value", (Throwable)e1);
            }
            ++n2;
        }
    }

    private IndexPersistence() {
    }

    public static void load(UnpackedElementIndex index, DataInputStream di, IBuildPath pb) throws IOException {
        int readInt = di.readInt();
        int a = 0;
        while (a < readInt) {
            IModule m = IndexPersistence.readModule(di, pb);
            if (m != null) {
                int sz = di.readInt();
                long ts = di.readLong();
                index.recordTimeStamp(m, ts);
                int b = 0;
                while (b < sz) {
                    int category = di.readInt();
                    String path = di.readUTF();
                    Object value = IndexPersistence.readValue(di);
                    index.addEntry(category, path, value, m);
                    ++b;
                }
            }
            ++a;
        }
    }

    public static void store(UnpackedElementIndex index, DataOutputStream da, IBuildPath pb) throws IOException {
        IModule[] array = index.getAllModules();
        da.writeInt(array.length);
        IModule[] iModuleArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (m == null) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Could not write a module to the PHP index. Module was null.", (String)"com.aptana.editor.php/debug/indexer");
            } else {
                List list = (List)index.entries.get((Object)m);
                if (list == null) {
                    list = Collections.emptyList();
                }
                IndexPersistence.writeModule(da, m, pb);
                da.writeInt(list.size());
                da.writeLong(index.getTimeStamp(m));
                for (UnpackedEntry e : new ArrayList(list)) {
                    IndexPersistence.store(e, da);
                }
            }
            ++n2;
        }
    }

    private static void store(UnpackedEntry entry, DataOutputStream da) throws IOException {
        String entryPath = entry.getEntryPath();
        int category = entry.getCategory();
        Object value = entry.getValue();
        da.writeInt(category);
        da.writeUTF(entryPath);
        IndexPersistence.writeValue(da, value);
    }

    private static void writeValue(DataOutputStream da, Object value) throws IOException {
        if (value instanceof IReportable) {
            IReportable p = (IReportable)value;
            p.store(da);
            return;
        }
        throw new IllegalStateException("Illegal value:" + value);
    }

    private static Object readValue(DataInputStream di) throws IOException {
        int cat = di.readInt();
        if (cat == 1) {
            return new ClassPHPEntryValue(di);
        }
        if (cat == 3) {
            return new VariablePHPEntryValue(di);
        }
        if (cat == 2) {
            return new FunctionPHPEntryValue(di);
        }
        if (cat == 5) {
            return new IncludePHPEntryValue(di);
        }
        if (cat == 7) {
            return new LambdaFunctionPHPEntryValue(di);
        }
        IEntryValueFactory entryValueFactory = factories.get(cat);
        if (entryValueFactory != null) {
            return entryValueFactory.createValue(di);
        }
        throw new IOException("Index corrupted");
    }

    private static IModule readModule(DataInputStream di, IBuildPath pb) throws IOException {
        String readUTF = di.readUTF();
        Path pa = new Path(readUTF);
        return pb.getModuleByPath((IPath)pa);
    }

    private static void writeModule(DataOutputStream da, IModule module, IBuildPath pb) throws IOException {
        String portableString = module.getPath().toPortableString();
        da.writeUTF(portableString);
    }

    public static void writeTypeSet(Set<Object> types, DataOutputStream da) throws IOException {
        if (types == null) {
            da.writeInt(0);
            return;
        }
        da.writeInt(types.size());
        for (Object o : types) {
            IndexPersistence.writeType(o, da);
        }
    }

    public static Set<Object> readTypeSet(DataInputStream di) throws IOException {
        int readInt = di.readInt();
        if (readInt == 0) {
            return Collections.emptySet();
        }
        if (readInt == 1) {
            return Collections.singleton(IndexPersistence.readType(di));
        }
        HashSet<Object> t = new HashSet<Object>(readInt);
        int a = 0;
        while (a < readInt) {
            t.add(IndexPersistence.readType(di));
            ++a;
        }
        return t;
    }

    public static Object readType(DataInputStream di) throws IOException {
        int readInt = di.readInt();
        if (readInt == -1) {
            return null;
        }
        if (readInt == 0) {
            return di.readUTF().intern();
        }
        if (readInt == 1) {
            return AbstractPathReference.read(di);
        }
        if (readInt == 2) {
            int len = di.readInt();
            Object[] result = new Object[len];
            int a = 0;
            while (a < len) {
                result[a] = IndexPersistence.readType(di);
                ++a;
            }
            return result;
        }
        throw new IllegalArgumentException("Unknown type " + readInt);
    }

    public static void writeType(Object type, DataOutputStream da) throws IOException {
        if (type == null) {
            da.writeInt(-1);
            return;
        }
        if (type instanceof String) {
            da.writeInt(0);
            da.writeUTF((String)type);
            return;
        }
        if (type instanceof AbstractPathReference) {
            da.writeInt(1);
            AbstractPathReference p = (AbstractPathReference)type;
            p.write(da);
            return;
        }
        if (type instanceof Object[]) {
            Object[] tps = (Object[])type;
            da.writeInt(2);
            da.writeInt(tps.length);
            int a = 0;
            while (a < tps.length) {
                IndexPersistence.writeType(tps[a], da);
                ++a;
            }
            return;
        }
        if (type instanceof Collection) {
            Collection col = (Collection)type;
            da.writeInt(2);
            da.writeInt(col.size());
            for (Object obj : col) {
                IndexPersistence.writeType(obj, da);
            }
            return;
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }
}

